function validate_numeric(tmpName)
{
 	var tempChar;
 	var legalChar = "1234567890.";

 	for (var i = 0; i < tmpName.length; i++) 
	{
		tempChar = tmpName.charAt(i);
 		if (legalChar.indexOf(tempChar) == -1)
 			return false;
	}

 	return true;
}

function ValidName(tmpName)
{
	var tempChar;
	var illegalChar = "~`!@#$%^&*()+=|\\/\"\';:<>,?{}[]";

	tmpName = tmpName.toLowerCase();

	for (var i = 0; i < tmpName.length; i++) 
	{
		tempChar = tmpName.charAt(i);
 		if (illegalChar.indexOf(tempChar) != -1)
			return false;
	}

 	return true;
}

function checkEmail(email)
{
    var pattern=/(^[\-_\.a-zA-Z0-9]+)@((([0-9]{1,3}\.){3}([0-9]{1,3})((:[0-9])*))|(([a-zA-Z0-9\-]+)(\.[a-zA-Z]{2,})+(\.[a-zA-Z]{2})?((:[0-9])*)))/; 

    if (email.search(pattern) == -1) 
	return false;
    else
	if (email.length < 100)
		return true;
	else
		return false;
}

function checkLink(url)
{
    	var illegalChar = "!@#$%^&*()_+=|}]{[><,;~`";
    	var mandChar = ".";
	tmpName = url.toLowerCase();

	if (tmpName.length > 255)
		return false;
	for (var i = 0; i < tmpName.length; i++) 
	{
		tempChar = tmpName.charAt(i);
 		if (illegalChar.indexOf(tempChar) != -1)
			return false;
	}
}

function SpaceInName(tmpName)
{
	for (var i = 0; i < tmpName.length; i++) 
	{
		if (tmpName.charAt(i) ==' ')
			return false;
	}
 	return true;
}

function checkHex(tmpVal)
{
	// check to see if hex value, if it is make sure length is 7
    	var hexSign = "#";
	var illegalChar = "~`!@$%^&*()+=|\\/\"\';:<>,?{}[]";

	if (hexSign.indexOf(tmpVal.charAt(0)) != -1)
	{
	 	if (tmpVal.length != 7)
			return false;
	}else{
		return false;
	}

	for (var i = 0; i < tmpVal.length; i++) 
	{
		tempChar = tmpVal.charAt(i);
 		if (illegalChar.indexOf(tempChar) != -1)
			return false;
	}
	return true;
}

function check_value(frm)
{
	if (frm.Quantity.name)
	{
	    if (frm.Quantity.value != "")
	    {
		if (validate_numeric(frm.Quantity.value) == false )
		{
			alert("Quantity must only contain numbers.");
			frm.Quantity.value="";
			frm.Quantity.focus();
			return false;
		}

		if (frm.Quantity.value > 999999999)
		{
			alert("Quantity cannot exceed 999999999.");
			frm.Quantity.value="";
			frm.Quantity.focus();
			return false;
		}
	    }

	}

	if (frm.Limit)
	{
	    if (frm.Limit.value != "")
	    {
		if (validate_numeric(frm.Limit.value) == false )
		{
			alert("Order Limit must only contain numbers.");
			frm.Limit.value="";
			frm.Limit.focus();
			return false;
		}
	    }
	}

	if (frm.Weight)
	{
	    if (frm.Weight.value != "")
	    {
		if (validate_numeric(frm.Weight.value) == false )
		{
			alert("Weight must only contain numbers.");
			frm.Weight.value="";
			frm.Weight.focus();
			return false;
		}
	    }
		
	    if (frm.Weight.value.length > 13)
	    {
		alert('Weight cannot exceed more than 9999999999.99 value.');
		frm.Weight.focus();
		return false;
	    }
	   
	    var tmpVar = '.';
	    var splitVal;
	    if (frm.Weight.value.search(tmpVar) != -1)
	    {
		splitVal = frm.Weight.value.split(tmpVar);
		if ((splitVal[0] != "") && (splitVal[0].length > 10))
		{
			alert('Weight cannot have more than 9999999999.99');
			frm.Weight.focus();
			return false;
		}

		if (splitVal[1].length > 2)
		{
			alert('Weight cannot have more than 2 decimal places');
			frm.Weight.focus();
			return false;
		}
	    }else{
		if (frm.Weight.value.length > 10)
		{
			alert('Weight cannot have more than 9999999999.99');
			frm.Weight.focus();
			return false;
		}
	    }
	}

	if (frm.Price)
	{
	    if (frm.Price.value != "")
	    {
 		if (validate_numeric(frm.Price.value) == false || validate_money(frm.Price.value) == false)
 		{
	 		alert("The Price contains invalid characters OR contains more than 2 digits after the decimal place.");
	 		frm.Price.value ="";
	 		frm.Price.focus();
	 		return false;
 		}
 		if (frm.Price.value > 999999.99)
 		{
	 		alert("The Price cannot exceed $999999.99.");
	 		frm.Price.focus();
	 		return false;
 		}
	    }
	}

	if (frm.PartNo)
	{
		if (frm.PartNo.value.length > 20)
		{
			alert('Part number cannot exceed 20 characters');
			frm.PartNo.focus();
			return false;
		}
	}

	if (frm.SKU)
	{
		if (frm.SKU.value.length > 20)
		{
			alert('SKU length cannot exceed 20 characters');
			frm.SKU.focus();
			return false;
		}
	}

	if (frm.PName)
	{
		if (frm.PName.value.length > 99)
		{
			alert('Product Name cannot exceed 99 characters');
			frm.PName.focus();
			return false;
		}
	}

	if (frm.Size)
	{
   	    var tmpVar = /\,/;
    	    var splitVal;
    	    if (frm.Size.value.search(tmpVar) != -1)
    	    {
        	splitVal = frm.Size.value.split(tmpVar);
        	// check the number of digits after the decimal
		for (i=0; i< splitVal.length; i++)
		{
        	    if (splitVal[i].length > 49)
		    {
			alert("Each Size cannot exceed 49 characters");
			frm.Size.focus();
                        return false;
		    }
        	}
	    }
	}

	if (frm.ETA)
	{
		if (frm.ETA.value.length > 100)
		{
			alert('ETA Message cannot exceed 100 characters');
			frm.ETA.focus();
			return false;
		}
	}

	//  Check to see if SalePrice exists on this page
	if (frm.SalePrice)
	{
		if (frm.SalePrice.value != "")
		{
 			if (validate_numeric(frm.SalePrice.value) == false || validate_money(frm.SalePrice.value) == false)
 			{
	 			alert("The Sales Price contains invalid characters OR contains more than 2 digits after the decimal place.");
	 			frm.SalePrice.value ="";
	 			frm.SalePrice.focus();
	 			return false;
			}
 			if (frm.SalePrice.value > 999999.99)
 			{
	 		    alert("The Sale Price cannot exceed $999999.99.");
	 		    frm.SalePrice.focus();
	 		    return false;
 			}
		}
	}

	if (frm.enableShipNotice)
	{
	    for (i=0; i < frm.enableShipNotice.length; i++)
	    {
		if (frm.enableShipNotice[i].checked)
		{
			if (frm.enableShipNotice[i].value == 1)
			{
				if (frm.lowItemLimit.value == "")
				{
					alert('You must enter a Low Item Limit since you enabled shipping notification');
					frm.lowItemLimit.focus();
					return false;
				}
		
				if (frm.supplerEmailAddr.value == "")
				{
					alert('You must enter a supplier email address since you enabled shipping notification');
					frm.supplerEmailAddr.value == "";
					return false;
				}else{
					if (checkEmail(frm.supplerEmailAddr.value) == false)
					{
						alert('Invalid Supplier Email Address');
						frm.supplerEmailAddr.focus();
						return false;
					}
				}
			}
		}	
	    }
	}

	if (frm.Category)
	{
	    if (frm.Category.value == "New Category")
	    {
		if (frm.OtherCategory.value == "")
		{
			alert("Please enter a name for your new category");
			frm.OtherCategory.focus();
			return false;
		}
	    }

	    if(frm.OtherCategory.value.length > 99)
	    {
		alert('New Category cannot exceed 99 characters');
		frm.OtherCategory.focus();
		return false;
	    }
	}

	if (frm.Color)
	{
   	    var tmpVar = /\,/;
    	    var splitVal;
    	    if (frm.Color.value.search(tmpVar) != -1)
    	    {
        	splitVal = frm.Color.value.split(tmpVar);
        	// check the number of digits after the decimal
		for (i=0; i< splitVal.length; i++)
		{
        	    if (splitVal[i].length > 49)
		    {
			alert("Each color cannot exceed 49 characters");
			frm.Color.focus();
                        return false;
		    }
        	}
	    }
	}

	if (frm.Option1)
	{
		if(frm.Option1.value.length > 50)
		{
			alert('Option 1 cannot exceed 50 characters');
			frm.Option1.focus();
			return false;
		}
	}

	if (frm.Option2)
	{
		if(frm.Option2.value.length > 50)
		{
			alert('Option 2 cannot exceed 50 characters');
			frm.Option2.focus();
			return false;
		}
	}

	if (frm.Custom)
	{
		if(frm.Custom.value.length > 50)
		{
			alert('The custom field label cannot exceed 50 characters');
			frm.Custom.focus();
			return false;
		}
	}

	if (frm.Image)
	{
		if(frm.Image.value.length > 255)
		{
			alert('The image url cannot exceed 255 characters');
			frm.Image.focus();
			return false;
		}
	}


 	return true;
}

function check_Conf(frm)
{
	if (frm.Opt1Name.value.length > 20)
	{
		alert('Option 1 label cannot exceed 20 characters');
		frm.Opt1Name.focus();
		return false;
	}

	if (frm.Opt2Name.value.length > 20)
	{
		alert('Option 2 label cannot exceed 20 characters');
		frm.Opt2Name.focus();
		return false;
	}

	if (frm.DefaultETA.value.length > 255)
	{
		alert('Default ETA value cannot exceed 255');
		frm.DefaultETA.focus();
		return false;
	}

	if (frm.TaxState)
	{
		if (frm.TaxState.value != "")
		{
			//var tmpState;
			//tmpState = frm.TaxState.value;
			
			if (checkState(frm.TaxState.value.toUpperCase()) == false)
			{
				alert("You have entered an invalid state.");
				frm.TaxState.value = "";
				frm.TaxState.focus();
				return false;
			}
		}
	}	

	if (frm.TaxRate)
	{
		if (frm.TaxRate.value != "")
		{
 			if (validate_numeric(frm.TaxRate.value) == false || validate_money(frm.TaxRate.value) == false)
 			{
	 			alert("The Tax Rate contains invalid characters OR it has more than 2 digits after decimal place.");
	 			frm.TaxRate.focus();
	 			return false;
 			}

			if (frm.TaxRate.value > 100)
			{
				alert('Tax Rate cannot exceed 100%');
				frm.TaxRate.focus();
				return false;
			}
		}
	}

	if (frm.ShippingModel.value == "Flat Rate")
	{
		if (frm.ShippingFlat.value != "")
		{
 	
			if (frm.ShippingFlat.value > 99999.99)
                        {
                            alert("The Shipping Flat Rate cannot exceed $99999.99");
                            frm.ShippingFlat.focus();
                            return false;
                        }
		
			if (validate_numeric(frm.ShippingFlat.value) == false || validate_money(frm.ShippingFlat.value) == false)
 			{
	 			alert("The Shipping Flat Rate contains invalid characters OR The length is greater than 2 digits after decimal place.");
	 			frm.ShippingFlat.focus();
	 			return false;
			}
		}else{
			alert('You must enter the Shipping Flat Rate since you select Flat Rate');
			frm.ShippingFlat.focus();
			return false;
		}
	}

	if (frm.ShippingModel.value == "Per Item" || frm.ShippingModel.value == "By Weight" || frm.ShippingModel.value == "Percentage" )
	{
		if (frm.ShippingRate.value != "")
		{
 			if (validate_numeric(frm.ShippingRate.value) == false || validate_money(frm.ShippingRate.value) == false)
 			{
	 			alert("The Shipping Rate contains invalid characters OR The length is greater than 2 digits after decimal place.");
	 			frm.ShippingRate.focus();
	 			return false;
			}
		}else{
	 		alert("You must enter the shipping rate for the shipping method you selected.");
	 		frm.ShippingRate.focus();
	 		return false;
		}	
	}

	if (frm.ShippingMin)
	{
		if (frm.ShippingMin.value != "")
		{
 			if (validate_numeric(frm.ShippingMin.value) == false || validate_money(frm.ShippingMin.value) == false)
 			{
	 			alert("The Minimum Shipping Rate contains invalid characters OR The length is greater than 2 digits after decimal place.");
	 			frm.ShippingMin.focus();
	 			return false;
			}
		}
	}

	if (frm.ShippingMax)
	{
		if (frm.ShippingMax.value != "")
		{
 			if (validate_numeric(frm.ShippingMax.value) == false || validate_money(frm.ShippingMax.value) == false)
 			{
	 			alert("The Maximum Shipping Rate contains invalid characters OR The length is greater than 2 digits after decimal place.");
	 			frm.ShippingMax.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp0Cost)
	{
		if (frm.SOp0Cost.value != "")
		{
 			if (validate_numeric(frm.SOp0Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp0Cost.value ="";
	 			frm.SOp0Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp1Cost)
	{
		if (frm.SOp1Cost.value != "")
		{
 			if (validate_numeric(frm.SOp1Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp1Cost.value ="";
	 			frm.SOp1Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp2Cost)
	{
		if (frm.SOp2Cost.value != "")
		{
 			if (validate_numeric(frm.SOp2Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp2Cost.value ="";
	 			frm.SOp2Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp3Cost)
	{
		if (frm.SOp3Cost.value != "")
		{
 			if (validate_numeric(frm.SOp3Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp3Cost.value ="";
	 			frm.SOp3Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp4Cost)
	{
		if (frm.SOp4Cost.value != "")
		{
 			if (validate_numeric(frm.SOp4Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp4Cost.value ="";
	 			frm.SOp4Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp5Cost)
	{
		if (frm.SOp5Cost.value != "")
		{
 			if (validate_numeric(frm.SOp5Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp5Cost.value ="";
	 			frm.SOp5Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp6Cost)
	{
		if (frm.SOp6Cost.value != "")
		{
 			if (validate_numeric(frm.SOp6Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp6Cost.value ="";
	 			frm.SOp6Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp7Cost)
	{
		if (frm.SOp7Cost.value != "")
		{
 			if (validate_numeric(frm.SOp7Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp7Cost.value ="";
	 			frm.SOp7Cost.focus();
	 			return false;
			}
		}
	}

	if (frm.SOp8Cost)
	{
		if (frm.SOp8Cost.value != "")
		{
 			if (validate_numeric(frm.SOp8Cost.value) == false)
 			{
	 			alert("The additional shipping rate contains invalid characters.");
	 			frm.SOp8Cost.value ="";
	 			frm.SOp8Cost.focus();
	 			return false;
			}	
		}
	}

	if (frm.SOp0Desc.value.length > 99)
	{
		alert('Additional shipping options cannot exceed 99 characters');
		frm.SOp0Desc.focus();
		return false;
	}

	if (frm.SOp1Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp1Desc.focus();
		return false;
	}

	if (frm.SOp2Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp2Desc.focus();
		return false;
	}

	if (frm.SOp3Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp3Desc.focus();
		return false;
	}

	if (frm.SOp4Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp4Desc.focus();
		return false;
	}

	if (frm.SOp5Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp5Desc.focus();
		return false;
	}

	if (frm.SOp6Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp6Desc.focus();
		return false;
	}

	if (frm.SOp7Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp7Desc.focus();
		return false;
	}

	if (frm.SOp8Desc.value.length > 253)
	{
		alert('Description cannot exceed 253 characters');
		frm.SOp8Desc.focus();
		return false;
	}
}

function checkState(check) 
{
	var states = "ALAKAZARCACOCTDEDCFLGAHIIDILINIAKS";
        states += "KYLAMEMDMAMIMSMNMOMTNENMNVNHNJNMNY";
        states += "NCNDOHOKORPARISCSDTNTXUTVTVAWAWVWIWY";

        // Include the following to test for Canadian provinces.
        /* Canadian provinces included only if
           a second parameter is supplied and is set to true. */
        if (arguments[1])
           states += "ABBCMBNBNFNSONPEPQSK";
        /* If the string is found in an even position, the state
           is valid. */
	flag = 0;
	i1 = states.indexOf(check);
	while(i1 != -1)
	{
		if((i1 % 2) ==0)
		{
			flag = 1;
			break;
		}

		i1 = states.indexOf(check, i1+1);
	}


	return (flag ==1);

}

function check_InvRadio(frm)
{
    if(frm.ItemID)
    {
	if (!(frm.ItemID.name))
	{
	    for (i=0; i < frm.ItemID.length; i++)
	    {
		if (frm.ItemID[i].checked == true)
			return true;
	    }
	}else{
	    if (frm.ItemID.checked == true)
		return true;
	}
	alert('You must select an item to perform this function');
	return false;
    }

}

function valQuantity(frm)
{
	for (i=0; i<frm.elements.length; i++)
	{
		if (!(frm.elements[i].name.indexOf("Qty")))
		{
			if (frm.elements[i].value != "")
			{
				if(validate_numeric(frm.elements[i].value) == false)
				{
					alert('Quantity must be numeric');
					frm.elements[i].value = "";
					frm.elements[i].focus();
					return false;
				}
			}
		}
	}
}

function check_keyword(frm)
{
	if (frm.term.value == "" )
	{
		alert('Keyword must be specified to perform a search');
		frm.term.focus();
		return false;
	}	

	if (frm.term.value.length > 100)
	{
		alert('Keyword must be less than 100 characters');
		frm.term.focus();
		return false;
	}	
}

function check_CatName(frm)
{
	if (frm.NewCategory.value == "")
	{
		alert('You must enter a value for the new category');
		frm.NewCategory.focus();
		return false;
	}
	
	if (frm.NewCategory.value.length > 99)
	{
		alert('Category Name cannot exceed 99 characters');
		frm.NewCategory.focus();
		return false;
	}	
}

function check_DeleteAns(frm)
{
	for (i=0; i<frm.CanDelete.length; i++)
	{	
		if (frm.CanDelete[i].checked)
		{
			if (frm.CanDelete[i].value == "No")
			{
				alert('You must select Yes to delete all products in the category to delete the category');
				frm.CanDelete[i].focus();
				return false;
			}
		}
	}	
}

function check_ModCat(frm)
{
    if (frm.Quantity.value != "" && frm.Quantity.value != "Enable" && frm.Quantity.value != "Disable" && frm.Quantity.value != "No Change") 
    {
	if (validate_numeric(frm.Quantity.value) == false)
	{
		alert('Quantity must be numeric');
		frm.Quantity.value == "";
		frm.Quantity.focus();
		return false;
	}
    }
}

function validate_OrderInfo(frm)
{
	if (frm.OrderName.value.length > 99)
	{
		alert('Order Dept Name cannot exceed 99 characters');
		frm.OrderName.focus();
		return false;
	}

	if (frm.OrderAddress.value.length > 100)
	{
		alert('Postal address cannot exceed 100 characters');
		frm.OrderAddress.focus();
		return false;
	}

	if (frm.OrderEmail.value != "")
	{
		if (checkEmail(frm.OrderEmail.value) == false)
		{
			alert('Email address is invalid');
			frm.OrderEmail.value == "";
			frm.OrderEmail.focus();
			return false;
		}
	}

	if (frm.InfoEmail.value != "")
	{
		if (checkEmail(frm.InfoEmail.value) == false)
		{
			alert('Informational Email address is invalid');
			frm.InfoEmail.value == "";
			frm.InfoEmail.focus();
			return false;
		}
	}

	if (checkPayments(frm) == false)
	{
		alert('You must select at least one payment option');
		return false;
	}

	if (frm.ReferQ.value.length > 50)
	{
		alert('Referer Question cannot exceed 50 characters.');
		frm.ReferQ.focus();
		return false;
	}

	if (checkPhone(frm.OrderPhone.value) == false)
	{	
		alert('Phone number is invalid');
		frm.OrderPhone.focus();
		return false;
	}

	if (checkPhone(frm.OrderFax.value) == false)
	{	
		alert('Fax number is invalid');
		frm.OrderFax.focus();
		return false;
	}

}

function checkPhone(tmpVal)
{
    if (tmpVal.length > 30)
    {
	return false;
    }else{
 	var tempChar;
 	var legalChar = "1234567890. +-(EXText)";

 	for (var i = 0; i < tmpVal.length; i++) 
	{
		tempChar = tmpVal.charAt(i);
 		if (legalChar.indexOf(tempChar) == -1)
 			return false;
	}
    }
    return true;
}

function checkPayments(frm)
{
	for (i=0; i< frm.AllowPayments.length; i++)
	{
		if (frm.AllowPayments[i].checked == true)
			return true;
	}
	return false;
}

function searchOptions(frm)
{
	for (i=0; i < frm.UseCats.length; i++)
	{
		if (frm.UseCats[i].checked == true)
		{
			if (frm.UseCats[i].value == 0)
			{
				frm.HaveSearch[0].checked = true;
			}
		}
	}
}

function searchCheck(frm)
{
	for (i=0; i < frm.UseCats.length; i++)
	{
		if (frm.UseCats[i].checked == true)
		{
			if (frm.UseCats[i].value == 0)
			{
				alert('You cannot enable the search engine unless you separate into categories');
				frm.HaveSearch[0].checked = true;
			}
		}
	}
}

function validate_Setup(frm)
{
	// Simple Setup
	if (frm.useHTMLFiles.value == 0)
	{
		if (frm.Title.value.length > 100)
		{
			alert('Shop Name cannot exceed 100 characters');
			frm.Title.focus();
			return false;
		}

		if (frm.CompanyName.value.length > 100)
		{
			alert('Company Name cannot exceed 100 characters');
			frm.CompanyName.focus();
			return false;
		}

		if (frm.BGImage.value.length > 255)
		{
			alert('Background Image cannot exceed 255 characters');
			frm.BGImage.focus();
			return false;
		}

		if (frm.Logo.value.length > 100)
		{
			alert('Company Logo cannot exceed 100 characters');
			frm.Logo.focus();
			return false;
		}

		if (frm.CompanyEmail.value != "")
		{
			if (checkEmail(frm.CompanyEmail.value) == false)
			{
				alert('Email Address is invalid');
				frm.CompanyEmail.value == "";
				frm.CompanyEmail.focus();
				return false;
			}
		}
		
		if (frm.CompanyURL.value != "")
		{
			if (checkLink(frm.CompanyURL.value) == false)
			{
				alert('Homepage URL is invalid');
				frm.CompanyURL.focus();
				return false;
			}
		}
		
		if (frm.CompanyAddress.value.length > 100)
		{
			alert('Postal Address cannot exceed 100 characters');
			frm.CompanyAddress.focus();
			return false;
		}

		if (frm.CompanyPhone.value != "")
		{
			if (checkPhone(frm.CompanyPhone.value) == false)
			{
				alert('Phone Number is Invalid');
				frm.CompanyPhone.focus();
				return false;
			}
		}

		if (frm.CompanyFax.value != "")
		{
			if (checkPhone(frm.CompanyFax.value) == false)
			{
				alert('Fax Number is Invalid');
				frm.CompanyFax.focus();
				return false;
			}
		}

		if (frm.BGColor.value == "Other")
		{
			if (frm.OtherBGColor.value == "")
			{
				alert('You must enter a value because you selected other color');
				frm.OtherBGColor.focus();
				return false;
			}else{
				if (checkHex(frm.OtherBGColor.value) == false)
				{
					alert('You have entered an invalid hex value');
					frm.OtherBGColor.focus();
					return false;
				}
			}
		}

		if (frm.FGColor.value == "Other")
		{
			if (frm.OtherFGColor.value == "")
			{
				alert('You must enter a value because you selected other color');
				frm.OtherFGColor.focus();
				return false;
			}else{
				if (checkHex(frm.OtherFGColor.value) == false)
				{
					alert('You have entered an invalid hex value');
					frm.OtherFGColor.focus();
					return false;
				}
			}
		}

		if (frm.LinkColor.value == "Other")
		{
			if (frm.OtherLinkColor.value == "")
			{
				alert('You must enter a value because you selected other color');
				frm.OtherLinkColor.focus();
				return false;
			}else{
				if (checkHex(frm.OtherLinkColor.value) == false)
				{
					alert('You have entered an invalid hex value');
					frm.OtherLinkColor.focus();
					return false;
				}
			}
		}

		if (frm.VLinkColor.value == "Other")
		{
			if (frm.OtherVLinkColor.value == "")
			{
				alert('You must enter a value because you selected other color');
				frm.OtherVLinkColor.focus();
				return false;
			}else{
				if (checkHex(frm.OtherVLinkColor.value) == false)
				{
					alert('You have entered an invalid hex value');
					frm.OtherVLinkColor.focus();
					return false;
				}
			}
		}

		if (frm.ALinkColor.value == "Other")
		{
			if (frm.OtherALinkColor.value == "")
			{
				alert('You must enter a value because you selected other color');
				frm.OtherALinkColor.focus();
				return false;
			}else{
				if (checkHex(frm.OtherALinkColor.value) == false)
				{
					alert('You have entered an invalid hex value');
					frm.OtherALinkColor.focus();
					return false;
				}
			}
		}
	}else{
		// Custom Setup
		if (frm.HeadFile.value == "")
		{
			alert('For Custom Setup, You must specify the header file path');
			frm.HeadFile.focus();
			return false;
		}

		if (frm.HeadFile.value.length > 100)
		{
			alert('The header file path cannot exceed 100 characters');
			frm.HeadFile.focus();
			return false;
		}

		if (frm.TailFile.value == "")
		{
			alert('For Custom Setup, You must specify the footer file path');
			frm.TailFile.focus();
			return false;
		}

		if (frm.TailFile.value.length > 100)
		{
			alert('The Footer file path cannot exceed 100 characters');
			frm.TailFile.focus();
			return false;
		}
	}

	if (frm.PageCt.value != "")
	{
		if (validate_numeric(frm.PageCt.value) == false)
		{
			alert('Maximum Items Per Page must be numeric');
			frm.PageCt.value = "";
			frm.PageCt.focus();
			return false;
		}
	}

	if (frm.CheckoutURL.value != "")
	{
		if (checkLink(frm.CheckoutURL.value) == false)
		{
			alert('Checkout URL is invalid');
			frm.CheckoutURL.focus();
			return false;
		}
	}

	if (frm.CookieTime.value != "")
	{
		if (validate_numeric(frm.CookieTime.value) == false)
		{
			alert('Cookie Timeout value must be numeric');
			frm.CookieTime.value = "";
			frm.CookieTime.focus();
			return false;
		}
	}
	
	if (frm.PageCt.value > 9999)
	{
		alert('Maximum items per page cannot exceed 9999');
		frm.PageCt.value = "";
		frm.PageCt.focus();
		return false;
	}
	
}

function checkOrder(frm)
{
	if (valSequence(frm) == false)
		return false;
}

function valSequence(frm)
{
	for (i=0; i<frm.elements.length; i++)
	{
		if (!(frm.elements[i].name.indexOf("Seq")))
		{
			if (frm.elements[i].value != "")
			{
				if(validate_numeric(frm.elements[i].value) == false)
				{
					alert('Quantity must be numeric');
					frm.elements[i].value = "";
					frm.elements[i].focus();
					return false;
				}
			}
		}
	}
}

function validate_money(amt)
{
    //var tmpVar = /\./;
    var tmpVar = '.';
    var splitVal;
    if (amt.search(tmpVar) != -1)
    {
	splitVal = amt.split(tmpVar);
	// check the number of digits after the decimal
	if (splitVal[1])
	{
	    if (splitVal[1].length > 2)
		return false;
	}else{
	    if (splitVal[0].length > 9)
		return false;
	}    
    }
}

function checkDate(frm)
{
 var dtEvent = new Date();

  dtEvent.setFullYear(frm.s_yy.value, frm.s_mm.value-1, frm.s_dd.value) ;
  var begDate = frm.s_mm.value + " " + frm.s_dd.value + " " + frm.s_yy.value;
  var endDate = frm.e_mm.value + " " + frm.e_dd.value + " " + frm.e_yy.value;


  if(!(dtEvent.getYear() == frm.s_yy.value && dtEvent.getMonth()+1 == frm.s_mm.value && dtEvent.getDate() == frm.s_dd.value))
  {
	alert('Invalid beginning date');
 	return false;	
  }

  dtEvent.setFullYear(frm.e_yy.value, frm.e_mm.value-1, frm.e_dd.value) ;

  if(!(dtEvent.getYear() == frm.e_yy.value && dtEvent.getMonth()+1 == frm.e_mm.value && dtEvent.getDate() == frm.e_dd.value))
  {
	alert('Invalid ending date');
 	return false;	
  }

  if (parseInt(frm.s_yy.value) > parseInt(frm.e_yy.value))
  {
	alert('Beginning date cannot come before starting date');
	frm.s_yy.focus();
	return false;
  }else{
     if (parseInt(frm.s_yy.value) == parseInt(frm.e_yy.value))
     {
	if (parseInt(frm.s_mm.value) > parseInt(frm.e_mm.value))
	{
	    alert('Beginning date cannot come before starting date');
	    frm.s_mm.focus();
	    return false;
	}else{
	    if (parseInt(frm.s_mm.value) == parseInt(frm.e_mm.value))
	    { 
	        if (parseInt(frm.s_dd.value) > parseInt(frm.e_dd.value))
	        {
	      	    alert('Beginning date cannot come before starting date');
		    frm.s_dd.focus();
	    	    return false;
		}
	    }
 	}
      }
  }

  // now we have to check the percentage		
  if (validate_numeric(frm.DiscPer.value) == false)
  {
	alert('Invalid Discount Percentage');
	frm.DiscPer.focus();
	return false;
  }
 
  if (validate_money(frm.DiscPer.value) == false)
  {
 	alert('Invalid Discount Percentage');
	frm.DiscPer.focus();
	return false;
  }
  
}	

function checkImport(frm)
{
    if((frm.datapath.value.length == 0) && (frm.datafile.value.length == 0))
    {
	alert('You must enter a file to import data from');
	frm.datapath.focus();
	return false;
    }

    if((frm.datapath.value.length > 0) && (frm.datafile.value.length > 0))
    {
	alert('You can only import one datafile at a time');
	frm.datapath.focus();
	return false;
    } 

    if( (frm.delimiter.value.length == 0) || ((frm.delimiter.value.length > 1) && ( ! ((frm.delimiter.value=="tab") || (frm.delimiter.value=="TAB") || (frm.delimiter.value=="Tab") || (frm.delimiter.value=="TAb") || (frm.delimiter.value=="TaB")  || (frm.delimiter.value=="taB") ) ) ) )
    {
        alert('Delimiter cannot be blank and can not be more than 1 character long except tab');
        frm.delimiter.focus();
	return false;
    }



    /*if(frm.delimiter.value.length == 0)
    {
        alert('Delimiter cannot be blank');
        frm.delimiter.focus();
	return false;
    }*/
  
    if(frm.delimiter.value == ",")
    {
        alert('Delimiter cannot be a comma');
        frm.delimiter.focus();
	return false;
    }

    var illegalChar = "cedfghijklmnopqrsuvwxyz1234567890";

    tmpName = frm.delimiter.value.toLowerCase();

    for (var i = 0; i < tmpName.length; i++) 
    {
	tempChar = tmpName.charAt(i);
 	if (illegalChar.indexOf(tempChar) != -1)
	{
	    alert('Invalid delimiter');
	    frm.delimiter.focus();
  	    return false;
	}
    }
}

function checkMivaImport(frm)
{
    if((frm.datapath.value.length == 0) && (frm.file1.value.length == 0) && (frm.file2.value.length == 0) && (frm.file3.value.length == 0) && (frm.file4.value.length == 0))
    {
	alert('You must enter a file to import data from');
	frm.datapath.focus();
	return false;
    }
}

function checkExport(frm)
{
    if(frm.savefile.value.length == 0)
    {
	alert('Export file must be specified');
	frm.savefile.focus();
	return false;
    }

    if(frm.delimiter.value.length == 0)
    {
        alert('Delimiter cannot be blank');
        frm.delimiter.focus();
	return false;
    }
}

function Valid_pwd(pwd1,pwd2) 
{
  var input1 = pwd1;
  var input2 = pwd2;
  var num= "0123456789";
  var letter= "abcdefghijklmnopqristuvwxyz";
  var capletter= "ASDFGHJKLPOIUYTREWQZXCVBNM";

  if(input1.length == 0 || input2.length == 0)
  {
      alert("You must enter both the password and confirmation password");
      return false;
  }

  if(input1.length<4 )
  {
      alert("Password must be more than 4 characters long.");
          return false;
  }

  for (i=0;i<input1.length;i++)
  {
      a=input1.charAt(i);
      if(!(num.indexOf(a)!=-1||letter.indexOf(a)!=-1||capletter.indexOf(a)!=-1))
      {
           alert("Password contains invalid character(s).");
               return false;
      }
  }

  if(input1!=input2)
  {
      alert("New and Re-Enter passwords do not match.");
          return false;
  }

}

function ValidTrackingNameCheck(tmpName)
     {
        var tempChar;
        var legalChar = "1234567890.ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

        for (var i = 0; i < tmpName.length; i++) {
            tempChar = tmpName.charAt(i)
            if (legalChar.indexOf(tempChar) == -1)
                return false;
            }

        return true;
     }

function check_tracking_len(frm)
{
    if ( frm.trackNum.value=="" )
    {
        alert('Please enter tracking number, it can not be blank');
        frm.trackNum.focus();
        return false;
    }       
    
    if( frm.trackNum.value.length > 49 )
    {
        alert('Tracking Number length should be greater than 1 and less that 49 characters.');
        frm.trackNum.focus();
        return false;
    }
	
   if(frm.trackNum.value != "")
    {
        if (ValidTrackingNameCheck(frm.trackNum.value) == false)
        {
            alert("The Tracking Number contains invalid characters.  Please enter alpha-numeric characters only.");
            frm.trackNum.value ="";
            frm.trackNum.focus();
            return false;
        }
    }

return true;
} 
